 ; Ŀ
 ;   Xing - Crossing locator and breaker.                                  
 ;   Copyright 1994, 2010 by Rocket Software Ltd.                          
 ;   Software to help alleviate the tedium of mindless labour.             
 ; 

 ; Ŀ
 ;   Xingo - subroutine - take two lines and their intersection as         
 ;   arguments, cuts one and adds any resulting new entities to the ss.    
 ;   Don't forget to update the data on the line which was cut before ret. 
 ; 
 (DEFUN XINGO (lin1 lin2 intrs chdist / last ang1 ang2 enampt ptx pty cut1
                                                                 cut2 nulast)
  (setq last (entlast))
 ; Ŀ
 ;   First decide which line to cut.  Get the two angles.                  
 ; 
  (setq ang1 (angle (cdr (assoc 10 (entget lin1)))
                    (cdr (assoc 11 (entget lin1)))))
  (setq ang2 (angle (cdr (assoc 10 (entget lin2)))
                    (cdr (assoc 11 (entget lin2)))))
 ; Ŀ
 ;   Reduce both angles to <= 180.                                        
 ; 
  (if (< pi ang1) (setq ang1 (- ang1 pi)))
  (if (< pi ang2) (setq ang2 (- ang2 pi)))
 ; Ŀ
 ;   And see which is closest to 90.  (ie cut that one.)                  
 ; 
  (if (< (abs (- (/ pi 2) ang1))                   ; if ang1 is closer to 90
         (abs (- (/ pi 2) ang2)))                  ; than ang2
      (progn
           (setq enampt (list lin1 intrs))         ; then break line 1
           (setq ang ang1))                        ; and use angle1
      (progn
           (setq enampt (list lin2 intrs))         ; otherwise break line 2
           (setq ang ang2)))                       ; and use angle2
 ; Ŀ
 ;   Now cut the line.  It would be possible to angle the cut distances    
 ;   to match the line, but I have made the cuts at 90.                   
 ; 
;  (setq cut1 (polar intrs ang chdist))            ; first cutpoint
;  (setq cut2 (polar intrs ang (- chdist)))        ; second cutpoint
  (if (= ang (/ pi 2))
      (setq hyp chdist)
      (setq hyp (/ chdist (cos (abs (- (/ pi 2) ang))))))
  (setq cut1 (polar intrs ang hyp))
  (setq cut2 (polar intrs ang (- hyp)))
  (command "break" enampt "f" cut1 cut2)           ; break the line
 ; Ŀ
 ;   As each line is broken see if a new entity was created and if so      
 ;   (if not the previous entlast) add it to the ss.                       
 ; 
  (setq nulast (entlast))
  (if (/= nulast last)
      (ssadd nulast ss))
 (princ))
 ; Ŀ
 ;   Xingo end.                                                            
 ; 

 ; Ŀ
 ;   Xing - the brain.                                                     
 ; 
 (DEFUN C:XING (/ blip oz breaks s t1 dimscl ss str chds num enam pos1 lll lln
                                                      a1 b2 rat ra c3 d4 xx t2)
  (setvar "cmdecho" 0)
  (setq blip (getvar "blipmode"))                  ; save blipmode
  (setq oz (getvar "osmode"))                      ; save osnapmode
  (setq breaks 0)                                  ; initialize break counter
 ; Ŀ
 ;   Save the current time (elapsed seconds in the current day).           
 ; 
  (setq s (getvar "date"))
  (setq t1 (* 86400.0 (- s (fix s))))
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Get the scale, depending on which space we are in and other things.   
 ; 
  (if misps
      (setq dimscl (misps))
      (setq dimscl (getvar "dimscale")))
 ; Ŀ
 ;   Get the lines to check and the break halfwidth.                       
 ; 
  (write-line "Select lines you wish to involve: ")
  (setq ss (ssget))                         ; get lines to check
  (if ss
      (progn
           (setvar "osmode" 0)              ; so osnaps won't alter point picks
           (if (and (/= (type chdist) 'REAL)
                    (/= (type chdist) 'INT))
               (setq chdist (* dimscl 1.5)))
           (setq str (strcat "Break halfwidth <" (rtos chdist 2 2) ">:"))
           (setq chds (getdist str))
           (if chds (setq chdist chds))
 ; Ŀ
 ;   Now remove anything from the ss which isn't a line.                   
 ; 
           (setq num 0)                            ; ss position counter
           (while (setq enam (ssname ss num))
                  (if (= (cdr (assoc 0 (entget enam))) "LINE")
                      (setq num (1+ num))
                      (ssdel enam ss)))))
 ; Ŀ
 ;   Now see if each line in the ss intersects any of the others.  If      
 ;   it does then add the intersection to the breakpoint list.             
 ;   Start with the first (index 0) line and check each one against all    
 ;   those after it for intersections.                                     
 ;   If any are found then call Xingo to break them.                       
 ; 
  (setvar "blipmode" 0)
  (setq pos1 0)                                    ; current entity position
  (while (and ss (setq lll (ssname ss pos1)))      ; while entity #1 exists
         (setq num (1+ pos1))                      ; 2nd ent pos
         (setq lll (ssname ss pos1))               ; 1st entity name
         (setq lln (entget lll))                   ; the whole thing
         (setq a1 (cdr (assoc 10 lln)))            ; its start
         (setq b2 (cdr (assoc 11 lln)))            ; its end
         (while (setq rat (ssname ss num))         ; while next entity exists
                (setq ra (entget rat))             ; its name
                (setq c3 (cdr (assoc 10 ra)))      ; its start
                (setq d4 (cdr (assoc 11 ra)))      ; its end
                (if (and a1 b2 c3 d4)
                    (setq xx (inters a1 b2 c3 d4)) ; see if it intersects 1st
                    (setq xx ()))
                (if (and xx                        ; if it does
                        (not (or (equal xx a1)     ; and it's not a line end
                                 (equal xx b2)
                                 (equal xx c3)
                                 (equal xx d4))))
                    (progn
 ; Ŀ
 ;   The two current lines crossed: call subroutine Xingo to break the     
 ;   correct line and add any new entities to ss.  Also re-entget lll,     
 ;   the line against which the others are being checked, in case it has   
 ;   changed (had one end chopped off).                                    
 ; 
                         (setq breaks (1+ breaks)) ; increment break counter
                         (xingo lll rat xx chdist) ; and break the line.
                         (setq lln (entget lll))   ; reacquire master line data
                         (setq a1 (cdr (assoc 10 lln)))    ; start
                         (setq b2 (cdr (assoc 11 lln)))))  ; and end
                (setq num (1+ num)))               ; go to next entity
         (setq pos1 (1+ pos1)))                    ; next master check entity
 ; Ŀ
 ;   Report how many lines were broken.                                    
 ; 
  (if (= 1 breaks)
      (write-line "1 intersection obliterated"))
  (if (< 1 breaks)
      (write-line (strcat (itoa breaks) " intersections fenestrated")))
  (if (= 0 breaks)
      (write-line "There are no useable intersections, cretin."))
 ; Ŀ
 ;   Now get the new current time, subtract it from the start time, and    
 ;   print the difference.                                                 
 ; 
  (setq s (getvar "date"))
  (setq t2 (* 86400.0 (- s (fix s))))
  (write-line (strcat "Elapsed time: " (rtos (- t2 t1) 2 1) " seconds "))
  (setvar "osmode" oz)                                       ; save osnapmode
  (setvar "blipmode" blip)
 (princ))